/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.EmissiveTextures;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartAnimations;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.TextureProperties;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureUtils {
    private static final String texGrassTop = "grass_block_top";
    private static final String texGrassSide = "grass_block_side";
    private static final String texGrassSideOverlay = "grass_block_side_overlay";
    private static final String texSnow = "snow";
    private static final String texGrassSideSnowed = "grass_block_snow";
    private static final String texMyceliumSide = "mycelium_side";
    private static final String texMyceliumTop = "mycelium_top";
    private static final String texWaterStill = "water_still";
    private static final String texWaterFlow = "water_flow";
    private static final String texLavaStill = "lava_still";
    private static final String texLavaFlow = "lava_flow";
    private static final String texFireLayer0 = "fire_0";
    private static final String texFireLayer1 = "fire_1";
    private static final String texSoulFireLayer0 = "soul_fire_0";
    private static final String texSoulFireLayer1 = "soul_fire_1";
    private static final String texCampFire = "campfire_fire";
    private static final String texCampFireLogLit = "campfire_log_lit";
    private static final String texSoulCampFire = "soul_campfire_fire";
    private static final String texSoulCampFireLogLit = "soul_campfire_log_lit";
    private static final String texPortal = "nether_portal";
    private static final String texGlass = "glass";
    private static final String texGlassPaneTop = "glass_pane_top";
    public static ilp iconGrassTop;
    public static ilp iconGrassSide;
    public static ilp iconGrassSideOverlay;
    public static ilp iconSnow;
    public static ilp iconGrassSideSnowed;
    public static ilp iconMyceliumSide;
    public static ilp iconMyceliumTop;
    public static ilp iconWaterStill;
    public static ilp iconWaterFlow;
    public static ilp iconLavaStill;
    public static ilp iconLavaFlow;
    public static ilp iconFireLayer0;
    public static ilp iconFireLayer1;
    public static ilp iconSoulFireLayer0;
    public static ilp iconSoulFireLayer1;
    public static ilp iconCampFire;
    public static ilp iconCampFireLogLit;
    public static ilp iconSoulCampFire;
    public static ilp iconSoulCampFireLogLit;
    public static ilp iconPortal;
    public static ilp iconGlass;
    public static ilp iconGlassPaneTop;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    public static final amo LOCATION_SPRITE_EMPTY;
    public static final amo LOCATION_TEXTURE_EMPTY;
    public static final amo WHITE_TEXTURE_LOCATION;
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;
    private static Map<Integer, String> mapTextureAllocations;
    private static Map<amo, amo> mapSpriteLocations;
    private static amo LOCATION_ATLAS_PAINTINGS;
    private static Throwable modelLoadingException;

    public static void update() {
        ilo mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = "minecraft:block/";
        iconGrassTop = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "grass_block_top"));
        iconGrassSide = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "grass_block_side"));
        iconGrassSideOverlay = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "grass_block_side_overlay"));
        iconSnow = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "snow"));
        iconGrassSideSnowed = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "grass_block_snow"));
        iconMyceliumSide = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "mycelium_side"));
        iconMyceliumTop = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "mycelium_top"));
        iconWaterStill = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "water_still"));
        iconWaterFlow = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "water_flow"));
        iconLavaStill = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "lava_still"));
        iconLavaFlow = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "lava_flow"));
        iconFireLayer0 = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "fire_0"));
        iconFireLayer1 = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "fire_1"));
        iconSoulFireLayer0 = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "soul_fire_0"));
        iconSoulFireLayer1 = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "soul_fire_1"));
        iconCampFire = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "campfire_fire"));
        iconCampFireLogLit = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "campfire_log_lit"));
        iconSoulCampFire = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "soul_campfire_fire"));
        iconSoulCampFireLogLit = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "soul_campfire_log_lit"));
        iconPortal = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "nether_portal"));
        iconGlass = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "glass"));
        iconGlassPaneTop = TextureUtils.getSpriteCheck((ilo)mapBlocks, (String)(prefix + "glass_pane_top"));
        String prefixItems = "minecraft:item/";
        mapSpriteLocations.clear();
    }

    public static ilp getSpriteCheck(ilo textureMap, String name) {
        ilp sprite = textureMap.getUploadedSprite(name);
        if (sprite == null || ilf.isMisingSprite((ilp)sprite)) {
            Config.warn((String)("Sprite not found: " + name));
        }
        return sprite;
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i2;
        for (i2 = 1; i2 < val; i2 *= 2) {
        }
        return i2;
    }

    public static int getPowerOfTwo(int val) {
        int i2 = 1;
        int po2 = 0;
        while (i2 < val) {
            i2 *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i2 = 0; i2 < power; ++i2) {
            val *= 2;
        }
        return val;
    }

    public static ikz getTexture(amo loc) {
        ikz tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource((amo)loc)) {
            return null;
        }
        tex = new ili(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesPreReload(baz rm) {
        modelLoadingException = null;
        Config.dbg((String)"*** Reloading resources ***");
        TextureProperties.update();
        CustomItems.update();
    }

    public static Throwable getModelLoadingException() {
        return modelLoadingException;
    }

    public static void setModelLoadingException(Throwable exceptionIn) {
        modelLoadingException = exceptionIn;
    }

    public static void resourcesReloaded(baz rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg((String)"*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        CustomItems.updateModels();
        CustomEntityModels.update();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        CustomPanorama.update();
        CustomGuis.update();
        ibe.update();
        CustomLoadingScreens.update();
        CustomBlockLayers.update();
        SmartAnimations.update();
        Config.getTextureManager().a();
        Config.dbg((String)"Disable Forge light pipeline");
        ReflectorForge.setForgeLightPipelineEnabled((boolean)false);
    }

    public static ilo getTextureMapBlocks() {
        return Config.getTextureMapBlocks();
    }

    public static void registerResourceListener() {
        baz rm = Config.getResourceManager();
        if (rm instanceof baw) {
            baw rrm = (baw)rm;
            1 rl = new /* Unavailable Anonymous Inner Class!! */;
            rrm.a((bat)rl);
            2 rmrl = new /* Unavailable Anonymous Inner Class!! */;
            rrm.a((bat)rmrl);
        }
    }

    public static void registerTickableTextures() {
        3 tt = new /* Unavailable Anonymous Inner Class!! */;
        amo ttl = new amo("optifine/tickable_textures");
        Config.getTextureManager().a(ttl, (ikz)tt);
    }

    public static void registerCustomModels(Map<amo, bax> mapModels) {
        CustomItems.registerModels(mapModels);
    }

    public static void registerCustomSprites(ilo textureMap) {
        if (textureMap.isTerrain()) {
            Config.dbg((String)"Register block sprites");
            ConnectedTextures.updateIcons((ilo)textureMap);
            BetterGrass.updateIcons((ilo)textureMap);
        }
        if (textureMap.isItems()) {
            Config.dbg((String)"Register item sprites");
            CustomItems.registerIcons((ilo)textureMap);
        }
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void registerCustomSpriteLocations(amo atlasLocation, Set<amo> spriteLocations) {
        RandomEntities.registerSprites((amo)atlasLocation, spriteLocations);
    }

    public static void refreshCustomSprites(ilo textureMap) {
        if (textureMap.isTerrain()) {
            Config.dbg((String)"Update block sprites");
            ConnectedTextures.refreshIcons((ilo)textureMap);
            BetterGrass.refreshIcons((ilo)textureMap);
        }
        if (textureMap.isItems()) {
            Config.dbg((String)"Update item sprites");
            CustomItems.updateIcons((ilo)textureMap);
        }
        EmissiveTextures.refreshIcons((ilo)textureMap);
    }

    public static amo fixResourceLocation(amo loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath((String)path, (String)basePath);
        if (pathFixed != path) {
            loc = new amo(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String defaultNamespace = "minecraft:";
        if (((String)path).startsWith(defaultNamespace)) {
            path = StrUtils.removePrefix((String)path, (String)defaultNamespace);
            return path;
        }
        String strAssMc = "assets/minecraft/";
        if (((String)path).startsWith(strAssMc)) {
            path = ((String)path).substring(strAssMc.length());
            return path;
        }
        if (((String)path).startsWith("./")) {
            path = ((String)path).substring(2);
            if (!((String)basePath).endsWith("/")) {
                basePath = (String)basePath + "/";
            }
            path = (String)basePath + (String)path;
            return path;
        }
        if (((String)path).startsWith("/~")) {
            path = ((String)path).substring(1);
        }
        String strOptifine = "optifine/";
        if (((String)path).startsWith("~/")) {
            path = ((String)path).substring(2);
            path = strOptifine + (String)path;
            return path;
        }
        if (((String)path).startsWith("/")) {
            path = strOptifine + ((String)path).substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        GlStateManager._bindTexture((int)glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int x2 = bgj.c((int)x);
        return x2 == x;
    }

    public static fyh scaleImage(fyh ni, int w2) {
        BufferedImage bi = TextureUtils.toBufferedImage((fyh)ni);
        BufferedImage bi2 = TextureUtils.scaleImage((BufferedImage)bi, (int)w2);
        fyh ni2 = TextureUtils.toNativeImage((BufferedImage)bi2);
        return ni2;
    }

    public static BufferedImage toBufferedImage(fyh ni) {
        int width = ni.a();
        int height = ni.b();
        int[] data = new int[width * height];
        ni.getBufferRGBA().get(data);
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, data, 0, width);
        return bi;
    }

    private static fyh toNativeImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        fyh ni = new fyh(width, height, false);
        ni.getBufferRGBA().put(data);
        return ni;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        int sizeNew;
        if (size == sizeGrid) {
            return size;
        }
        for (sizeNew = size / sizeGrid * sizeGrid; sizeNew < size; sizeNew += sizeGrid) {
        }
        return sizeNew;
    }

    public static int scaleToMin(int size, int sizeMin) {
        int sizeNew;
        if (size >= sizeMin) {
            return size;
        }
        for (sizeNew = sizeMin / size * size; sizeNew < sizeMin; sizeNew += size) {
        }
        return sizeNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e2) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void dbgMipmaps(ilp textureatlassprite) {
        fyh[] mipmapImages = textureatlassprite.getMipmapImages();
        for (int l2 = 0; l2 < mipmapImages.length; ++l2) {
            fyh image = mipmapImages[l2];
            if (image == null) {
                Config.dbg((String)(l2 + ": " + String.valueOf(image)));
                continue;
            }
            Config.dbg((String)(l2 + ": " + image.a() * image.b()));
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        TextureUtils.bindTexture((int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        name = StrUtils.removeSuffix((String)name, (String)".png");
        File fileBase = new File(name);
        File dir = fileBase.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            String namePng = name + "_" + i2 + ".png";
            File filePng = new File(namePng);
            filePng.delete();
        }
        for (int level = 0; level <= mipmapLevels; ++level) {
            File filePng = new File(name + "_" + level + ".png");
            int widthLevel = width >> level;
            int heightLevel = height >> level;
            int sizeLevel = widthLevel * heightLevel;
            IntBuffer buf = BufferUtils.createIntBuffer((int)sizeLevel);
            int[] data = new int[sizeLevel];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buf);
            buf.get(data);
            BufferedImage image = new BufferedImage(widthLevel, heightLevel, 2);
            image.setRGB(0, 0, widthLevel, heightLevel, data, 0, widthLevel);
            try {
                ImageIO.write((RenderedImage)image, "png", filePng);
                Config.dbg((String)("Exported: " + String.valueOf(filePng)));
                continue;
            }
            catch (Exception e2) {
                Config.warn((String)("Error writing: " + String.valueOf(filePng)));
                Config.warn((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            }
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        for (int i2 = 65536; i2 > 0; i2 >>= 1) {
            GlStateManager._texImage2D((int)32868, (int)0, (int)6408, (int)i2, (int)i2, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            int err = GL11.glGetError();
            int width = GlStateManager._getTexLevelParameter((int)32868, (int)0, (int)4096);
            if (width == 0) continue;
            return i2;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            BufferedImage bufferedImage = bufferedimage = ImageIO.read(imageStream);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    public static int toAbgr(int argb) {
        int a2 = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb >> 0 & 0xFF;
        int abgr = a2 << 24 | b2 << 16 | g2 << 8 | r;
        return abgr;
    }

    public static void resetDataUnpacking() {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
    }

    public static String getStackTrace(Throwable t) {
        CharArrayWriter caw = new CharArrayWriter();
        t.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    public static void debugTextureGenerated(int id) {
        mapTextureAllocations.put(id, TextureUtils.getStackTrace((Throwable)new Throwable("StackTrace")));
        Config.dbg((String)("Textures: " + mapTextureAllocations.size()));
    }

    public static void debugTextureDeleted(int id) {
        mapTextureAllocations.remove(id);
        Config.dbg((String)("Textures: " + mapTextureAllocations.size()));
    }

    public static ilp getCustomSprite(ilp sprite) {
        if (sprite == null) {
            return null;
        }
        if (Config.isRandomEntities()) {
            sprite = RandomEntities.getRandomSprite((ilp)sprite);
        }
        if (EmissiveTextures.isActive()) {
            sprite = EmissiveTextures.getEmissiveSprite((ilp)sprite);
        }
        return sprite;
    }

    public static amo getSpriteLocation(amo loc) {
        amo locSprite = (amo)mapSpriteLocations.get(loc);
        if (locSprite == null) {
            String pathSprite = loc.a();
            pathSprite = StrUtils.removePrefix((String)pathSprite, (String)"textures/");
            pathSprite = StrUtils.removeSuffix((String)pathSprite, (String)".png");
            locSprite = new amo(loc.b(), pathSprite);
            mapSpriteLocations.put(loc, locSprite);
        }
        return locSprite;
    }

    public static int generateTextureId() {
        RenderSystem.assertOnRenderThread();
        return GlStateManager._genTexture();
    }

    public static void releaseTextureId(int textureId) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._deleteTexture((int)textureId);
    }

    public static void prepareImage(int textureId, int width, int height) {
        TextureUtils.prepareImage((fyh.a)fyh.a.a, (int)textureId, (int)0, (int)width, (int)height);
    }

    public static void prepareImage(fyh.a pixelFormat, int textureId, int width, int height) {
        TextureUtils.prepareImage((fyh.a)pixelFormat, (int)textureId, (int)0, (int)width, (int)height);
    }

    public static void prepareImage(int textureId, int mipmapLevel, int width, int height) {
        TextureUtils.prepareImage((fyh.a)fyh.a.a, (int)textureId, (int)mipmapLevel, (int)width, (int)height);
    }

    public static void prepareImage(fyh.a pixelFormat, int textureId, int mipmapLevel, int width, int height) {
        RenderSystem.assertOnRenderThread();
        TextureUtils.bindTexture((int)textureId);
        if (mipmapLevel >= 0) {
            GlStateManager._texParameter((int)3553, (int)33085, (int)mipmapLevel);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)mipmapLevel);
            GlStateManager.texParameter((int)3553, (int)34049, (float)0.0f);
        }
        for (int i2 = 0; i2 <= mipmapLevel; ++i2) {
            GlStateManager._texImage2D((int)3553, (int)i2, (int)GlConst.toGl((fyh.a)pixelFormat), (int)(width >> i2), (int)(height >> i2), (int)0, (int)6408, (int)5121, null);
        }
    }

    static {
        LOCATION_SPRITE_EMPTY = new amo("optifine/ctm/default/empty");
        LOCATION_TEXTURE_EMPTY = new amo("optifine/ctm/default/empty.png");
        WHITE_TEXTURE_LOCATION = new amo("optifine/textures/white16.png");
        staticBuffer = Config.createDirectIntBuffer((int)256);
        glMaximumTextureSize = -1;
        mapTextureAllocations = new HashMap();
        mapSpriteLocations = new HashMap();
        LOCATION_ATLAS_PAINTINGS = new amo("textures/atlas/paintings.png");
    }
}

