/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.resource.DelegatingPackResources;
import net.optifine.Config;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResUtils {
    public static String[] collectFiles(String prefix, String suffix) {
        return ResUtils.collectFiles((String[])new String[]{prefix}, (String[])new String[]{suffix});
    }

    public static String[] collectFiles(String[] prefixes, String[] suffixes) {
        LinkedHashSet<String> setPaths = new LinkedHashSet<String>();
        azl[] rps = Config.getResourcePacks();
        for (int i2 = 0; i2 < rps.length; ++i2) {
            azl rp = rps[i2];
            String[] ps = ResUtils.collectFiles((azl)rp, (String[])prefixes, (String[])suffixes, null);
            setPaths.addAll(Arrays.asList(ps));
        }
        String[] paths = setPaths.toArray(new String[setPaths.size()]);
        return paths;
    }

    public static String[] collectFiles(azl rp, String prefix, String suffix, String[] defaultPaths) {
        return ResUtils.collectFiles((azl)rp, (String[])new String[]{prefix}, (String[])new String[]{suffix}, (String[])defaultPaths);
    }

    public static String[] collectFiles(azl rp, String[] prefixes, String[] suffixes) {
        return ResUtils.collectFiles((azl)rp, (String[])prefixes, (String[])suffixes, null);
    }

    public static String[] collectFiles(azl rp, String[] prefixes, String[] suffixes, String[] defaultPaths) {
        if (rp instanceof aze) {
            aze crp = (aze)rp;
            LinkedHashSet<String> pathsSet = new LinkedHashSet<String>();
            for (azl subRp : crp.d) {
                String[] subPaths = ResUtils.collectFiles((azl)subRp, (String[])prefixes, (String[])suffixes, (String[])defaultPaths);
                pathsSet.addAll(Arrays.asList(subPaths));
            }
            String[] paths = pathsSet.toArray(new String[pathsSet.size()]);
            return paths;
        }
        if (rp instanceof DelegatingPackResources) {
            return new String[0];
        }
        if (rp instanceof azp) {
            return ResUtils.collectFilesFixed((azl)rp, (String[])defaultPaths);
        }
        File tpFile = null;
        if (rp instanceof azi) {
            azi fpr = (azi)rp;
            tpFile = fpr.getFile();
        } else if (rp instanceof azo) {
            azo ppr = (azo)rp;
            tpFile = ppr.e.toFile();
        } else {
            Config.warn((String)("Unknown resource pack type: " + String.valueOf(rp)));
            return new String[0];
        }
        if (tpFile == null) {
            return new String[0];
        }
        if (tpFile.isDirectory()) {
            return ResUtils.collectFilesFolder((File)tpFile, (String)"", (String[])prefixes, (String[])suffixes);
        }
        if (tpFile.isFile()) {
            return ResUtils.collectFilesZIP((File)tpFile, (String[])prefixes, (String[])suffixes);
        }
        Config.warn((String)("Unknown resource pack file: " + String.valueOf(tpFile)));
        return new String[0];
    }

    private static String[] collectFilesFixed(azl rp, String[] paths) {
        if (paths == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            if (!ResUtils.isLowercase((String)path)) {
                Config.warn((String)("Skipping non-lowercase path: " + path));
                continue;
            }
            amo loc = new amo(path);
            if (!Config.hasResource((azl)rp, (amo)loc)) continue;
            list.add(path);
        }
        String[] pathArr = list.toArray(new String[list.size()]);
        return pathArr;
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String[] prefixes, String[] suffixes) {
        ArrayList<Object> list = new ArrayList<Object>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                Object name = basePath + file.getName();
                if (!((String)name).startsWith(prefixAssets) || !StrUtils.startsWith((String)(name = ((String)name).substring(prefixAssets.length())), (String[])prefixes) || !StrUtils.endsWith((String)name, (String[])suffixes)) continue;
                if (!ResUtils.isLowercase((String)name)) {
                    Config.warn((String)("Skipping non-lowercase path: " + (String)name));
                    continue;
                }
                list.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            String[] names = ResUtils.collectFilesFolder((File)file, (String)dirPath, (String[])prefixes, (String[])suffixes);
            for (int n2 = 0; n2 < names.length; ++n2) {
                String name = names[n2];
                list.add(name);
            }
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private static String[] collectFilesZIP(File tpFile, String[] prefixes, String[] suffixes) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile zf2 = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = zf2.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String name = ze.getName();
                if (!name.startsWith(prefixAssets) || !StrUtils.startsWith((String)(name = name.substring(prefixAssets.length())), (String[])prefixes) || !StrUtils.endsWith((String)name, (String[])suffixes)) continue;
                if (!ResUtils.isLowercase((String)name)) {
                    Config.warn((String)("Skipping non-lowercase path: " + name));
                    continue;
                }
                list.add(name);
            }
            zf2.close();
            String[] names = list.toArray(new String[list.size()]);
            return names;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return new String[0];
        }
    }

    private static boolean isLowercase(String str) {
        return str.equals(str.toLowerCase(Locale.ROOT));
    }

    public static Properties readProperties(String path, String module) {
        amo loc = new amo(path);
        try {
            InputStream in = Config.getResourceStream((amo)loc);
            if (in == null) {
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg((String)(module + ": Loading " + path));
            return props;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (IOException e3) {
            Config.warn((String)(module + ": Error reading " + path));
            return null;
        }
    }

    public static Properties readProperties(InputStream in, String module) {
        if (in == null) {
            return null;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            return props;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (IOException e3) {
            return null;
        }
    }
}

