/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public abstract class AbstractMapMap<K1, K2, V> {
    private Map<K1, Map<K2, V>> mapMap = this.makeMap();

    abstract Map makeMap();

    public V put(K1 key1, K2 key2, V val) {
        Map map = (Map)this.mapMap.get(key1);
        if (map == null) {
            map = this.makeMap();
            this.mapMap.put(key1, map);
        }
        return map.put(key2, val);
    }

    public V get(K1 key1, K2 key2) {
        Map map = (Map)this.mapMap.get(key1);
        if (map == null) {
            return null;
        }
        return map.get(key2);
    }

    public Map<K2, V> get(K1 key1) {
        return (Map)this.mapMap.get(key1);
    }

    public Set<K2> keySet(K1 key1) {
        Map map = (Map)this.mapMap.get(key1);
        if (map == null) {
            return Set.of();
        }
        return map.keySet();
    }

    public boolean containsKey(K1 key1) {
        Map map = (Map)this.mapMap.get(key1);
        if (map == null) {
            return false;
        }
        return !map.isEmpty();
    }

    public boolean containsKey(K1 key1, K2 key2) {
        Map map = (Map)this.mapMap.get(key1);
        if (map == null) {
            return false;
        }
        return map.containsKey(key2);
    }

    public V computeIfAbsent(K1 key1, K2 key2, BiFunction<K1, K2, V> func) {
        Object val = this.get(key1, key2);
        if (val == null && !this.containsKey(key1, key2)) {
            val = func.apply(key1, key2);
            this.put(key1, key2, val);
        }
        return (V)val;
    }

    public Collection<V> values() {
        ArrayList vals = new ArrayList();
        for (Map map : this.mapMap.values()) {
            vals.addAll(map.values());
        }
        return vals;
    }
}

