/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.gui;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.SlotGui;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.gui.GuiShaders;
import net.optifine.util.ResUtils;

class GuiSlotShaders
extends SlotGui {
    private ArrayList shaderslist;
    private int selectedIndex;
    private long lastClicked = Long.MIN_VALUE;
    private long lastClickedCached = 0L;
    final GuiShaders shadersGui;

    public GuiSlotShaders(GuiShaders par1GuiShaders, int width, int height, int top, int bottom, int slotHeight) {
        super(par1GuiShaders.getMc(), width, height, top, bottom, slotHeight);
        this.shadersGui = par1GuiShaders;
        this.updateList();
        this.yScroll = 0.0;
        int posYSelected = this.selectedIndex * slotHeight;
        int wMid = (bottom - top) / 2;
        if (posYSelected > wMid) {
            this.scroll(posYSelected - wMid);
        }
    }

    public int getRowWidth() {
        return this.width - 20;
    }

    public void updateList() {
        this.shaderslist = Shaders.listOfShaders();
        this.selectedIndex = 0;
        int n2 = this.shaderslist.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((String)this.shaderslist.get(i2)).equals(Shaders.currentShaderName)) continue;
            this.selectedIndex = i2;
            break;
        }
    }

    protected int getItemCount() {
        return this.shaderslist.size();
    }

    protected boolean selectItem(int index, int buttons, double x, double y2) {
        if (index == this.selectedIndex && this.lastClicked == this.lastClickedCached) {
            return false;
        }
        String name = (String)this.shaderslist.get(index);
        IShaderPack sp = Shaders.getShaderPack((String)name);
        if (!this.checkCompatible(sp, index)) {
            return false;
        }
        this.selectIndex(index);
        return true;
    }

    private void selectIndex(int index) {
        this.selectedIndex = index;
        this.lastClickedCached = this.lastClicked;
        Shaders.setShaderPack((String)((String)this.shaderslist.get(index)));
        Shaders.uninit();
        this.shadersGui.updateButtons();
    }

    private boolean checkCompatible(IShaderPack sp, int index) {
        if (sp == null) {
            return true;
        }
        InputStream in = sp.getResourceAsStream("/shaders/shaders.properties");
        Properties props = ResUtils.readProperties((InputStream)in, (String)"Shaders");
        if (props == null) {
            return true;
        }
        String keyVer = "version.1.21.11";
        String relMin = props.getProperty(keyVer);
        if (relMin == null) {
            return true;
        }
        String rel = "J9";
        int res = Config.compareRelease((String)rel, (String)(relMin = relMin.trim()));
        if (res >= 0) {
            return true;
        }
        String verMin = ("HD_U_" + relMin).replace('_', ' ');
        String msg1 = imu.a((String)"of.message.shaders.nv1", (Object[])new Object[]{verMin});
        String msg2 = imu.a((String)"of.message.shaders.nv2", (Object[])new Object[0]);
        int theIndex = index;
        BooleanConsumer callback = result -> {
            if (result) {
                this.selectIndex(theIndex);
            }
            this.minecraft.a((gsb)this.shadersGui);
        };
        gra guiYesNo = new gra(callback, (yh)yh.b((String)msg1), (yh)yh.b((String)msg2));
        this.minecraft.a((gsb)guiYesNo);
        return false;
    }

    protected boolean isSelectedItem(int index) {
        return index == this.selectedIndex;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getItemHeight() {
        return this.getItemCount() * 18;
    }

    protected void renderBackground() {
    }

    protected void renderItem(gir graphicsIn, int index, int posX, int posY, int contentY, int mouseX, int mouseY, float partialTicks) {
        Object label = (String)this.shaderslist.get(index);
        if (((String)label).equals("OFF")) {
            label = Lang.get((String)"of.options.shaders.packNone");
        } else if (((String)label).equals("(debug)")) {
            label = Lang.get((String)"of.options.shaders.packDefault");
        } else if (!((String)label).toLowerCase().endsWith(".zip")) {
            label = "<" + (String)label + ">";
        }
        this.shadersGui.drawCenteredString(graphicsIn, (String)label, this.width / 2, posY + 1, -2039584);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean a(double mouseX, double mouseY, double deltaH, double deltaV) {
        return super.a(mouseX, mouseY, deltaH, deltaV * 3.0);
    }
}

