/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.optifine.render.RegionRenderData;
import net.optifine.render.VboRegion;
import net.optifine.util.PairInt;
import org.joml.Matrix4fc;

public class RegionRenderer {
    private hth layer;
    private Map<PairInt, Map<VboRegion, List<hto>>> mapPosRegionBuffers = new LinkedHashMap(16);
    private int lastRegionX = Integer.MIN_VALUE;
    private int lastRegionZ = Integer.MIN_VALUE;
    private Map<VboRegion, List<hto>> lastRegionBuffers;
    private VboRegion lastVboRegion;
    private List<hto> lastBuffers;

    public RegionRenderer(hth layer) {
        this.layer = layer;
    }

    public void addSection(int regionX, int regionZ, hto buffersIn) {
        VboRegion vboRegion;
        if (regionX != this.lastRegionX || regionZ != this.lastRegionZ) {
            PairInt pos = PairInt.of((int)regionX, (int)regionZ);
            this.lastRegionBuffers = this.mapPosRegionBuffers.computeIfAbsent(pos, k -> new LinkedHashMap(8));
            this.lastRegionX = regionX;
            this.lastRegionZ = regionZ;
            this.lastVboRegion = null;
        }
        if ((vboRegion = buffersIn.getVboRegion()) != this.lastVboRegion) {
            this.lastBuffers = this.lastRegionBuffers.computeIfAbsent(vboRegion, k -> new ArrayList());
            this.lastVboRegion = vboRegion;
        }
        this.lastBuffers.add(buffersIn);
    }

    public void reset() {
        this.lastRegionX = Integer.MIN_VALUE;
        this.lastRegionZ = Integer.MIN_VALUE;
        this.lastRegionBuffers = null;
        this.lastVboRegion = null;
        this.lastBuffers = null;
    }

    public void finishPrepare(Matrix4fc viewIn, double xIn, double yIn, double zIn, List<hny.a> sectionInfos, EnumMap<hth, List<RenderPass.a<GpuBufferSlice[]>>> mapLayerDraws, int atlasWidth, int atlasHeight) {
        for (Map.Entry entryPos : this.mapPosRegionBuffers.entrySet()) {
            PairInt pos = (PairInt)entryPos.getKey();
            if (entryPos.getValue() == null) continue;
            hny.a csi = new hny.a(viewIn, pos.getLeft(), 0, pos.getRight(), 1.0f, atlasWidth, atlasHeight, xIn, yIn, zIn);
            int uniformIndex = sectionInfos.size();
            sectionInfos.add(csi);
            RegionRenderData renderData = new RegionRenderData(this, pos);
            BiConsumer<GpuBufferSlice[], RenderPass.b> uniformUploader = (buffers2In, uploader2In) -> uploader2In.upload("ChunkSection", buffers2In[uniformIndex]);
            RenderPass.a draw = new RenderPass.a(0, null, null, null, 0, 0, uniformUploader, renderData, null);
            mapLayerDraws.get(this.layer).add((RenderPass.a<GpuBufferSlice[]>)draw);
        }
    }

    public void renderRegion(PairInt positionIn) {
        Map mapRegionBuffers = (Map)this.mapPosRegionBuffers.get(positionIn);
        if (this.mapPosRegionBuffers == null) {
            return;
        }
        for (Map.Entry entryRegionBuffers : mapRegionBuffers.entrySet()) {
            VboRegion region = (VboRegion)entryRegionBuffers.getKey();
            List listBuffers = (List)entryRegionBuffers.getValue();
            if (listBuffers.isEmpty()) continue;
            for (hto buffers : listBuffers) {
                buffers.drawInRegion();
            }
            region.finishDraw();
            listBuffers.clear();
        }
    }

    public void clear() {
        this.reset();
        this.mapPosRegionBuffers.clear();
    }

    public String toString() {
        return String.valueOf(this.layer);
    }
}

