/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final iz[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays((boolean)false);
    public static final iz[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays((boolean)true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static hif worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(hif world, cgk viewEntity, int renderDistanceChunks, hpr viewFrustum) {
        int minHeight = world.K_();
        int maxHeight = world.L_();
        int minChunkHeight = minHeight >> 4;
        int pcx = bgj.c((double)viewEntity.dP()) >> 4;
        int pcy = bgj.c((double)(viewEntity.dR() - (double)minHeight)) >> 4;
        int pcz = bgj.c((double)viewEntity.dV()) >> 4;
        int pcyMax = maxHeight - minHeight >> 4;
        pcy = Config.limit((int)pcy, (int)0, (int)(pcyMax - 1));
        long playerSectionKey = jw.c((is)viewEntity.dK());
        est playerSection = world.getSectionStorage().d(playerSectionKey);
        boolean multiplayer = !Config.isIntegratedServerRunning();
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            for (int cz = czStart; cz < czEnd; ++cz) {
                eqq chunk = world.d(cx, cz);
                if (chunk.F()) {
                    int i2;
                    if (!multiplayer || (i2 = viewFrustum.getHighestUsedChunkIndex(cx, iMax, cz)) <= iMax) continue;
                    iMax = i2;
                    continue;
                }
                eqr[] ebss = chunk.d();
                for (int i3 = ebss.length - 1; i3 > iMax; --i3) {
                    eqr ebs = ebss[i3];
                    if (ebs == null || ebs.c()) continue;
                    if (i3 <= iMax) break;
                    iMax = i3;
                    break;
                }
                try {
                    Map mapTileEntities = chunk.J();
                    if (mapTileEntities.isEmpty()) continue;
                    Set keys = mapTileEntities.keySet();
                    for (is pos : keys) {
                        int i4 = pos.v() - minHeight >> 4;
                        if (i4 <= iMax) continue;
                        iMax = i4;
                    }
                    continue;
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            LongSet sectionKeys = world.getSectionStorage().getSectionKeys();
            LongIterator it = sectionKeys.iterator();
            while (it.hasNext()) {
                long sectionKey = it.nextLong();
                int sectionY = jw.c((long)sectionKey);
                int i5 = sectionY - minChunkHeight;
                if (sectionKey == playerSectionKey && i5 == pcy && playerSection != null && playerSection.getEntityList().size() == 1 || i5 <= iMax) continue;
                iMax = i5;
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return (iMax << 4) + minHeight;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static iz[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        iz[][] arrs = new iz[count][];
        for (int i2 = 0; i2 < count; ++i2) {
            ArrayList<iz> list = new ArrayList<iz>();
            for (int ix = 0; ix < iz.x.length; ++ix) {
                iz facing = iz.x[ix];
                iz facingMask = opposite ? facing.g() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i2 & mask) == 0) continue;
                list.add(facing);
            }
            iz[] fs = list.toArray(new iz[list.size()]);
            arrs[i2] = fs;
        }
        return arrs;
    }

    public static iz[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static iz[] getFacings(int setDirections) {
        int index = setDirections & 0x3F;
        return enumFacingArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

