/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.util.Collections;
import java.util.List;
import net.optifine.util.TextureUtils;

public abstract class SlotGui
extends gmk
implements gpb {
    public static final amo WHITE_TEXTURE_LOCATION = TextureUtils.WHITE_TEXTURE_LOCATION;
    public static final amo MENU_LIST_BACKGROUND = new amo("textures/gui/menu_list_background.png");
    public static final amo INWORLD_MENU_LIST_BACKGROUND = new amo("textures/gui/inworld_menu_list_background.png");
    protected static final int NO_DRAG = -1;
    protected static final int DRAG_OUTSIDE = -2;
    protected final gfj minecraft;
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double yScroll;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public SlotGui(gfj mcIn, int width, int height, int topIn, int bottomIn, int slotHeightIn) {
        this.minecraft = mcIn;
        this.width = width;
        this.height = height;
        this.y0 = topIn;
        this.y1 = bottomIn;
        this.itemHeight = slotHeightIn;
        this.x0 = 0;
        this.x1 = width;
    }

    public void setRenderSelection(boolean flagIn) {
        this.renderSelection = flagIn;
    }

    protected void setRenderHeader(boolean headerIn, int heightIn) {
        this.renderHeader = headerIn;
        this.headerHeight = heightIn;
        if (!headerIn) {
            this.headerHeight = 0;
        }
    }

    public void setVisible(boolean flagIn) {
        this.visible = flagIn;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends gmm> aJ_() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int indexIn, int buttonIn, double mouseX, double mouseY) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground();

    protected void updateItemPosition(int index, int xIn, int yIn, float partialTicks) {
    }

    protected abstract void renderItem(gir var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(gir graphicsIn, int xIn, int yIn) {
    }

    protected void clickedHeader(int xIn, int yIn) {
    }

    protected void renderDecorations(int mouseX, int mouseY) {
    }

    public int getItemAtPosition(double mouseX, double mouseY) {
        int i2 = this.x0 + this.width / 2 - this.getRowWidth() / 2;
        int j = this.x0 + this.width / 2 + this.getRowWidth() / 2;
        int k = bgj.c((double)(mouseY - (double)this.y0)) - this.headerHeight + (int)this.yScroll - 4;
        int l2 = k / this.itemHeight;
        return mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)i2 && mouseX <= (double)j && l2 >= 0 && k >= 0 && l2 < this.getItemCount() ? l2 : -1;
    }

    protected void capYPosition() {
        this.yScroll = bgj.a((double)this.yScroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public void centerScrollOn(int indexIn) {
        this.yScroll = indexIn * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2;
        this.capYPosition();
    }

    public int getScroll() {
        return (int)this.yScroll;
    }

    public boolean isMouseInList(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= (double)this.x0 && mouseX <= (double)this.x1;
    }

    public int getScrollBottom() {
        return (int)this.yScroll - this.height - this.headerHeight;
    }

    public void scroll(int deltaIn) {
        this.yScroll += (double)deltaIn;
        this.capYPosition();
        this.yDrag = -2;
    }

    public void render(gir graphicsIn, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.renderBackground();
            this.capYPosition();
            fzo tessellator = fzo.b();
            amo menuListBackground = this.minecraft.r != null ? INWORLD_MENU_LIST_BACKGROUND : MENU_LIST_BACKGROUND;
            graphicsIn.a(menuListBackground, this.x0, this.y0, this.x1, this.y1, 0.0f, 1.0f, 0.0f, 1.0f);
            int k = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
            int l2 = this.y0 + 4 - (int)this.yScroll;
            if (this.renderHeader) {
                this.renderHeader(graphicsIn, k, l2);
            }
            this.renderList(graphicsIn, k, l2, mouseX, mouseY, partialTicks);
            int delta = 1;
            graphicsIn.blit(WHITE_TEXTURE_LOCATION, this.x0, this.y0, this.x1, this.y0 + delta, 0.0f, 1.0f, 0.0f, 1.0f, -16777216);
            graphicsIn.blit(WHITE_TEXTURE_LOCATION, this.x0, this.y1 - delta, this.x1, this.y1, 0.0f, 1.0f, 0.0f, 1.0f, -16777216);
            int j1 = this.getMaxScroll();
            if (j1 > 0) {
                int k1 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                int l1 = (int)this.yScroll * (this.y1 - this.y0 - (k1 = bgj.a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8)))) / j1 + this.y0;
                if (l1 < this.y0) {
                    l1 = this.y0;
                }
                int sy0 = this.getScrollbarPosition();
                int sy1 = sy0 + 6;
                graphicsIn.blit(WHITE_TEXTURE_LOCATION, sy0, this.y0, sy1, this.y1, 0.0f, 1.0f, 0.0f, 1.0f, -16777216);
                graphicsIn.blit(WHITE_TEXTURE_LOCATION, sy0, l1, sy1, l1 + k1, 0.0f, 1.0f, 0.0f, 1.0f, -8355712);
                graphicsIn.blit(WHITE_TEXTURE_LOCATION, sy0, l1, sy1 - 1, l1 + k1 - 1, 0.0f, 1.0f, 0.0f, 1.0f, -4144960);
            }
            this.renderDecorations(mouseX, mouseY);
        }
    }

    protected void updateScrollingState(double mouseX, double mouseY, int buttonIn) {
        this.scrolling = buttonIn == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean a(gzc eventIn, boolean doubleIn) {
        double mouseX = eventIn.u();
        double mouseY = eventIn.v();
        int button = eventIn.t();
        this.updateScrollingState(mouseX, mouseY, button);
        if (this.isVisible() && this.isMouseInList(mouseX, mouseY)) {
            int i2 = this.getItemAtPosition(mouseX, mouseY);
            if (i2 == -1 && button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.y0) + (int)this.yScroll - 4);
                return true;
            }
            if (i2 != -1 && this.selectItem(i2, button, mouseX, mouseY)) {
                if (this.aJ_().size() > i2) {
                    this.a((gmm)this.aJ_().get(i2));
                }
                this.c_(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean b(gzc eventIn) {
        if (this.aO_() != null) {
            this.aO_().b(eventIn);
        }
        return false;
    }

    public boolean a(gzc eventIn, double mouseX, double mouseY) {
        double mouseAbsX = eventIn.u();
        double mouseAbsY = eventIn.v();
        double deltaX = mouseX;
        double deltaY = mouseY;
        int buttonIn = eventIn.t();
        if (super.a(eventIn, deltaX, deltaY)) {
            return true;
        }
        if (this.isVisible() && buttonIn == 0 && this.scrolling) {
            if (mouseAbsY < (double)this.y0) {
                this.yScroll = 0.0;
            } else if (mouseAbsY > (double)this.y1) {
                this.yScroll = this.getMaxScroll();
            } else {
                double d0 = this.getMaxScroll();
                if (d0 < 1.0) {
                    d0 = 1.0;
                }
                int i2 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                double d1 = d0 / (double)(this.y1 - this.y0 - (i2 = bgj.a((int)i2, (int)32, (int)(this.y1 - this.y0 - 8))));
                if (d1 < 1.0) {
                    d1 = 1.0;
                }
                this.yScroll += deltaY * d1;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean a(double mouseX, double mouseY, double deltaH, double deltaV) {
        if (!this.isVisible()) {
            return false;
        }
        this.yScroll -= deltaV * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean a(gzb eventIn) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.a(eventIn)) {
            return true;
        }
        if (eventIn.t() == 264) {
            this.moveSelection(1);
            return true;
        }
        if (eventIn.t() == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int increment) {
    }

    public boolean a(gyy eventIn) {
        return !this.isVisible() ? false : super.a(eventIn);
    }

    public boolean a_(double mouseX, double mouseY) {
        return this.isMouseInList(mouseX, mouseY);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(gir graphicsIn, int xIn, int yIn, int mouseX, int mouseY, float partialTicks) {
        int count = this.getItemCount();
        fzo tessellator = fzo.b();
        graphicsIn.c(this.x0, this.y0, this.x1, this.y1);
        for (int i2 = 0; i2 < count; ++i2) {
            int yItem = yIn + i2 * this.itemHeight + this.headerHeight;
            int h = this.itemHeight - 4;
            if (yItem > this.y1 || yItem + h < this.y0) {
                this.updateItemPosition(i2, xIn, yItem, partialTicks);
            }
            if (Boolean.TRUE.booleanValue() && this.renderSelection && this.isSelectedItem(i2)) {
                int xt = this.x0 + this.width / 2 - this.getRowWidth() / 2;
                int yt = this.x0 + this.width / 2 + this.getRowWidth() / 2;
                float br = this.isFocusedNow() ? 1.0f : 0.5f;
                int col = bel.a((float)1.0f, (float)br, (float)br, (float)br);
                graphicsIn.a(xt, yItem - 2, yt, yItem + h + 2, col);
                int col2 = bel.a((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                graphicsIn.a(xt + 1, yItem - 1, yt - 1, yItem + h + 1, col2);
            }
            if (yItem + this.itemHeight < this.y0 || yItem > this.y1) continue;
            this.renderItem(graphicsIn, i2, xIn, yItem, h, mouseX, mouseY, partialTicks);
        }
        graphicsIn.f();
    }

    protected boolean isFocusedNow() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public void setLeftPos(int x0In) {
        this.x0 = x0In;
        this.x1 = x0In + this.width;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public gpb.a y() {
        return gpb.a.b;
    }

    public void b(gpd output) {
    }
}

