/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityRule;
import net.optifine.config.ConnectedParser;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntityProperties<T> {
    private String name = null;
    private String basePath = null;
    private RandomEntityContext<T> context;
    private T[] resources = null;
    private RandomEntityRule<T>[] rules = null;
    private int matchingRuleIndex = -1;

    public RandomEntityProperties(String name, amo baseLoc, int[] variants, RandomEntityContext<T> context) {
        ConnectedParser cp = new ConnectedParser(context.getName());
        this.name = name;
        this.basePath = cp.parseBasePath(baseLoc.a());
        this.context = context;
        this.resources = new Object[variants.length];
        for (int i2 = 0; i2 < variants.length; ++i2) {
            int index = variants[i2];
            this.resources[i2] = context.makeResource(name, baseLoc, index);
        }
    }

    public RandomEntityProperties(Properties props, String path, amo baseResLoc, RandomEntityContext<T> context) {
        ConnectedParser cp = context.getConnectedParser();
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.context = context;
        this.rules = this.parseRules(props, path, baseResLoc);
    }

    public String getName() {
        return this.name;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public T[] getResources() {
        return this.resources;
    }

    public List<T> getAllResources() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.resources != null) {
            list.addAll(Arrays.asList(this.resources));
        }
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (rule.getResources() == null) continue;
                list.addAll(Arrays.asList(rule.getResources()));
            }
        }
        return list;
    }

    public T getResource(IRandomEntity randomEntity, T resDef) {
        this.matchingRuleIndex = 0;
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (!rule.matches(randomEntity)) continue;
                this.matchingRuleIndex = rule.getIndex();
                int randomId = RandomEntityProperties.getRandomId((IRandomEntity)randomEntity, (boolean)rule.isSeedSourceVehicle(), (int)rule.getSeedOffset());
                return (T)rule.getResource(randomId, resDef);
            }
        }
        if (this.resources != null) {
            int randomId = RandomEntityProperties.getRandomId((IRandomEntity)randomEntity, (boolean)false, (int)0);
            int index = randomId % this.resources.length;
            return (T)this.resources[index];
        }
        return resDef;
    }

    private static int getRandomId(IRandomEntity randomEntityIn, boolean sourceVehicleIn, int seedOffsetIn) {
        int randomId;
        int n = randomId = sourceVehicleIn ? randomEntityIn.getVehicleId() : randomEntityIn.getId();
        if (seedOffsetIn != 0) {
            randomId ^= Config.intHash((int)seedOffsetIn);
        }
        return randomId;
    }

    private RandomEntityRule<T>[] parseRules(Properties props, String pathProps, amo baseResLoc) {
        ArrayList<RandomEntityRule> list = new ArrayList<RandomEntityRule>();
        SortedMap mapIndexTextures = this.collectIndexTextures(props);
        for (Map.Entry entry : mapIndexTextures.entrySet()) {
            int index = (Integer)entry.getKey();
            String valTextures = (String)entry.getValue();
            if (valTextures == null) continue;
            RandomEntityRule rule = new RandomEntityRule(props, pathProps, baseResLoc, index, valTextures, this.context);
            list.add(rule);
        }
        RandomEntityRule[] rules = list.toArray(new RandomEntityRule[list.size()]);
        return rules;
    }

    private SortedMap<Integer, String> collectIndexTextures(Properties props) {
        String[] keyPrefixes = this.context.getResourceKeys();
        TreeMap<Integer, String> indexMap = new TreeMap<Integer, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String indexStr;
            int index;
            String entryKeyNoPrefix;
            String entryKey = (String)entry.getKey();
            if (Config.equals((Object)entryKey, (Object)(entryKeyNoPrefix = StrUtils.removePrefix((String)entryKey, (String[])keyPrefixes))) || !entryKeyNoPrefix.startsWith(".") || (index = Config.parseInt((String)(indexStr = entryKeyNoPrefix.substring(1)), (int)0)) <= 0) continue;
            String entryVal = (String)entry.getValue();
            indexMap.put(index, entryVal);
        }
        return indexMap;
    }

    public boolean isValid(String path) {
        int i2;
        String resNamePlural = this.context.getResourceNamePlural();
        if (this.resources == null && this.rules == null) {
            Config.warn((String)("No " + resNamePlural + " specified: " + path));
            return false;
        }
        if (this.rules != null) {
            for (i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule rule = this.rules[i2];
                if (rule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resources != null) {
            for (i2 = 0; i2 < this.resources.length; ++i2) {
                Object res = this.resources[i2];
                if (res != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDefault() {
        if (this.rules != null) {
            return false;
        }
        return this.resources == null;
    }

    public int getMatchingRuleIndex() {
        return this.matchingRuleIndex;
    }

    public static RandomEntityProperties parse(amo propLoc, amo resLoc, RandomEntityContext context) {
        String contextName = context.getName();
        try {
            String path = propLoc.a();
            Config.dbg((String)(contextName + ": " + resLoc.a() + ", properties: " + path));
            InputStream in = Config.getResourceStream((amo)propLoc);
            if (in == null) {
                Config.warn((String)(contextName + ": Properties not found: " + path));
                return null;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            RandomEntityProperties rep = new RandomEntityProperties((Properties)props, path, resLoc, context);
            if (!rep.isValid(path)) {
                return null;
            }
            return rep;
        }
        catch (FileNotFoundException e) {
            Config.warn((String)(contextName + ": File not found: " + propLoc.a()));
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.name + ", path: " + this.basePath;
    }
}

