/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import net.optifine.ItemOverrideProperty;
import net.optifine.util.CompoundKey;

public class ItemOverrideCache {
    private ItemOverrideProperty[] itemOverrideProperties;
    private Map<CompoundKey, Integer> mapModelIndexes = new HashMap();
    public static final Integer INDEX_NONE = new Integer(-1);

    public ItemOverrideCache(ItemOverrideProperty[] itemOverrideProperties) {
        this.itemOverrideProperties = itemOverrideProperties;
    }

    public Integer getModelIndex(dlt stack, hif world, chl entity) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return null;
        }
        return (Integer)this.mapModelIndexes.get(valueKey);
    }

    public void putModelIndex(dlt stack, hif world, chl entity, Integer index) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return;
        }
        this.mapModelIndexes.put(valueKey, index);
    }

    private CompoundKey getValueKey(dlt stack, hif world, chl entity) {
        Object[] indexes = new Integer[this.itemOverrideProperties.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            Integer index = this.itemOverrideProperties[i2].getValueIndex(stack, world, entity);
            if (index == null) {
                return null;
            }
            indexes[i2] = index;
        }
        return new CompoundKey(indexes);
    }

    public String toString() {
        return "properties: " + this.itemOverrideProperties.length + ", modelIndexes: " + this.mapModelIndexes.size();
    }
}

