/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private cgk entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<is> setLitChunkPos = new HashSet();

    public DynamicLight(cgk entity) {
        this.entity = entity;
        this.offsetY = entity.dk();
    }

    public void update(hoh renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dP() - 0.5;
        double posY = this.entity.dR() - 0.5 + this.offsetY;
        double posZ = this.entity.dV() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((cgk)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            iz dirX = (bgj.c((double)posX) & 0xF) >= 8 ? iz.f : iz.e;
            iz dirY = (bgj.c((double)posY) & 0xF) >= 8 ? iz.b : iz.a;
            iz dirZ = (bgj.c((double)posZ) & 0xF) >= 8 ? iz.d : iz.c;
            long chunkPos = this.getChunkPos(posX, posY, posZ);
            hts.a chunk = renderGlobal.getRenderChunk(chunkPos);
            long chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            hts.a chunkX = renderGlobal.getRenderChunk(chunkPosX);
            long chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            hts.a chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            long chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            hts.a chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            long chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            hts.a chunkY = renderGlobal.getRenderChunk(chunkPosY);
            long chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            hts.a chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            long chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            hts.a chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            long chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            hts.a chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private long getChunkPos(double x, double y2, double z) {
        int cx = jw.a((int)bgj.c((double)x));
        int cy = jw.a((int)bgj.c((double)y2));
        int cz = jw.a((int)bgj.c((double)z));
        return jw.b((int)cx, (int)cy, (int)cz);
    }

    private long getChunkPos(hts.a renderChunk, long pos, iz facing) {
        int x = jw.b((long)pos);
        int y2 = jw.c((long)pos);
        int z = jw.d((long)pos);
        return jw.b((int)(x += facing.j()), (int)(y2 += facing.k()), (int)(z += facing.l()));
    }

    private void updateChunkLight(hts.a renderChunk, Set<is> setPrevPos, Set<is> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        htr compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.isEmpty()) {
            renderChunk.b(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        is pos = renderChunk.getPosition().j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(hoh renderGlobal) {
        for (is posOld : this.setLitChunkPos) {
            hts.a chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public cgk getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + String.valueOf(this.entity) + ", offsetY: " + this.offsetY;
    }
}

