/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import net.optifine.util.WorldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;
    private static fzm MATRIX_STACK = new fzm();

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    public static boolean isActive() {
        return worldSkyLayers != null;
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "optifine/sky/world";
        int lastWorldId = -1;
        for (int w = 0; w < wsls.length; ++w) {
            String worldPrefix = prefix + w;
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 0; i2 < 1000; ++i2) {
                String path = worldPrefix + "/sky" + i2 + ".properties";
                int countMissing = 0;
                try {
                    amo locPath = new amo(path);
                    InputStream in = Config.getResourceStream((amo)locPath);
                    if (in == null && ++countMissing > 10) break;
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    Config.dbg((String)("CustomSky properties: " + path));
                    String defSource = i2 + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer((Properties)props, defSource);
                    if (!sl.isValid(path)) continue;
                    String srcPath = StrUtils.addSuffixCheck((String)sl.source, (String)".png");
                    amo locSource = new amo(srcPath);
                    ikz tex = TextureUtils.getTexture((amo)locSource);
                    if (tex == null) {
                        Config.log((String)("CustomSky: Texture not found: " + String.valueOf(locSource)));
                        continue;
                    }
                    sl.gpuTexture = tex.b();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    if (++countMissing <= 10) continue;
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w] = sls;
            lastWorldId = w;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(dwo world, float partialTicks) {
        CustomSky.renderSky((dwo)world, (fzm)MATRIX_STACK, (float)partialTicks);
    }

    public static void renderSky(dwo world, fzm matrixStackIn, float partialTicks) {
        int dimId;
        if (worldSkyLayers == null) {
            return;
        }
        if (Config.isShaders()) {
            Shaders.setRenderStage((RenderStage)RenderStage.CUSTOM_SKY);
        }
        if ((dimId = WorldUtils.getDimensionId((dwo)world)) < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.al();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = WorldUtils.getCelestialAngle((float)partialTicks);
        float rainStrength = world.c(partialTicks);
        float thunderStrength = world.a(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl = sls[i2];
            if (!sl.isActive(world, timeOfDay)) continue;
            sl.render(world, matrixStackIn, timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        Blender.clearBlend();
    }

    public static boolean hasSkyLayers(dwo world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int dimId = WorldUtils.getDimensionId((dwo)world);
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

