/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.optifine.ComparableVersion;
import net.optifine.DynamicLights;
import net.optifine.GlErrors;
import net.optifine.SmartAnimations;
import net.optifine.TextureAnimations;
import net.optifine.VersionCheckThread;
import net.optifine.config.GlVersion;
import net.optifine.gui.GuiMessage;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.util.GlUtil;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

/*
 * Exception performing whole class analysis ignored.
 */
public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.21.11";
    public static final String OF_EDITION = "HD_U";
    public static final String OF_RELEASE = "J9";
    public static final String VERSION = "OptiFine_1.21.11_HD_U_J9";
    private static String build = null;
    private static String newRelease = null;
    private static boolean notify64BitJava = false;
    public static String openGlVersion = null;
    public static String openGlRenderer = null;
    public static String openGlVendor = null;
    public static String[] openGlExtensions = null;
    public static GlVersion glVersion = null;
    public static GlVersion glslVersion = null;
    public static int minecraftVersionInt = -1;
    private static gfo gameSettings = null;
    private static gfj minecraft = null;
    private static boolean initialized = false;
    private static Thread minecraftThread = null;
    private static int antialiasingLevel = 0;
    private static int availableProcessors = 0;
    public static boolean zoomMode = false;
    public static boolean zoomSmoothCamera = false;
    private static int texturePackClouds = 0;
    private static boolean fullscreenModeChecked = false;
    private static boolean desktopModeChecked = false;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean logDetail = System.getProperty("log.detail", "false").equals("true");
    private static long debugUpdateTimeLast = 0L;
    private static int fpsMinLast = 0;
    private static int chunkUpdatesLast = 0;
    private static ilo textureMapBlocks;
    private static ilo textureMapItems;
    private static long timeLastFrameMs;
    private static long averageFrameTimeMs;
    private static long lastFrameTimeMs;
    private static boolean showFrameTime;

    private Config() {
    }

    public static String getVersion() {
        return "OptiFine_1.21.11_HD_U_J9";
    }

    public static String getVersionDebug() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("OptiFine_1.21.11_HD_U_J9");
        if (Config.isDynamicLights()) {
            sb.append(", DL: ");
            sb.append(String.valueOf(DynamicLights.getCount()));
        }
        sb.append(", A: ");
        ilo tm = Config.getTextureMapBlocks();
        if (SmartAnimations.isActive()) {
            sb.append(tm.getCountAnimationsActive() + TextureAnimations.getCountAnimationsActive());
            sb.append("/");
        }
        sb.append(tm.getCountAnimations() + TextureAnimations.getCountAnimations());
        String shaderPack = Shaders.getShaderPackName();
        if (shaderPack != null) {
            sb.append(", ");
            sb.append(shaderPack);
        }
        return sb.toString();
    }

    public static void initMinecraft(gfj minecraftIn) {
        minecraft = minecraftIn;
    }

    public static void initGameSettings(gfo settings) {
        if (gameSettings != null) {
            return;
        }
        gameSettings = settings;
        Config.updateAvailableProcessors();
        ReflectorForge.putLaunchBlackboard((String)"optifine.ForgeSplashCompatible", (Object)Boolean.TRUE);
        String forgeVer = (String)Reflector.ForgeVersion_getVersion.call(new Object[0]);
        if (forgeVer != null) {
            Config.dbg((String)("Forge version: " + forgeVer));
            ComparableVersion cv = new ComparableVersion(forgeVer);
            ComparableVersion cvMax = new ComparableVersion("47.0.3");
            if (cv.compareTo(cvMax) > 1) {
                Config.dbg((String)("Forge version above " + String.valueOf(cvMax) + ", antialiasing disabled"));
                Config.gameSettings.ofAaLevel = 0;
            }
        }
        antialiasingLevel = Config.gameSettings.ofAaLevel;
    }

    public static void initDisplay() {
        Config.checkInitialized();
        minecraftThread = Thread.currentThread();
        Config.updateThreadPriorities();
        Shaders.startup((gfj)gfj.V());
    }

    public static void checkInitialized() {
        if (initialized) {
            return;
        }
        if (gfj.V().aR() == null) {
            return;
        }
        initialized = true;
        Config.checkOpenGlCaps();
        Config.startVersionCheckThread();
    }

    private static void checkOpenGlCaps() {
        Config.log((String)"");
        Config.log((String)Config.getVersion());
        Config.log((String)("Build: " + Config.getBuild()));
        Config.log((String)("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version")));
        Config.log((String)("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor")));
        Config.log((String)("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor")));
        Config.log((String)("LWJGL: " + GLFW.glfwGetVersionString()));
        openGlVersion = GL11.glGetString((int)7938);
        openGlRenderer = GL11.glGetString((int)7937);
        openGlVendor = GL11.glGetString((int)7936);
        Config.log((String)("OpenGL: " + openGlRenderer + ", version " + openGlVersion + ", " + openGlVendor));
        Config.log((String)("OpenGL Version: " + Config.getOpenGlVersionString()));
        int maxTexSize = TextureUtils.getGLMaximumTextureSize();
        Config.dbg((String)("Maximum texture size: " + maxTexSize + "x" + maxTexSize));
    }

    public static String getBuild() {
        if (build == null) {
            try {
                InputStream in = Config.getOptiFineResourceStream((String)"/buildof.txt");
                if (in == null) {
                    return null;
                }
                build = Config.readLines((InputStream)in)[0];
            }
            catch (Exception e) {
                Config.warn((String)(e.getClass().getName() + ": " + e.getMessage()));
                build = "";
            }
        }
        return build;
    }

    public static InputStream getOptiFineResourceStream(String name) {
        InputStream in = ReflectorForge.getOptiFineResourceStream((String)name);
        if (in != null) {
            return in;
        }
        return Config.class.getResourceAsStream(name);
    }

    public static int getMinecraftVersionInt() {
        if (minecraftVersionInt < 0) {
            String mcVer = "1.21.11";
            if (mcVer.contains("-")) {
                mcVer = Config.tokenize((String)mcVer, (String)"-")[0];
            }
            String[] verStrs = Config.tokenize((String)mcVer, (String)".");
            int ver = 0;
            if (verStrs.length > 0) {
                ver += 10000 * Config.parseInt((String)verStrs[0], (int)0);
            }
            if (verStrs.length > 1) {
                ver += 100 * Config.parseInt((String)verStrs[1], (int)0);
            }
            if (verStrs.length > 2) {
                ver += 1 * Config.parseInt((String)verStrs[2], (int)0);
            }
            minecraftVersionInt = ver;
        }
        return minecraftVersionInt;
    }

    public static String getOpenGlVersionString() {
        GlVersion ver = Config.getGlVersion();
        String verStr = ver.getMajor() + "." + ver.getMinor() + "." + ver.getRelease();
        return verStr;
    }

    private static GlVersion getGlVersionLwjgl() {
        GLCapabilities glCapabilities = GL.getCapabilities();
        if (glCapabilities.OpenGL44) {
            return new GlVersion(4, 4);
        }
        if (glCapabilities.OpenGL43) {
            return new GlVersion(4, 3);
        }
        if (glCapabilities.OpenGL42) {
            return new GlVersion(4, 2);
        }
        if (glCapabilities.OpenGL41) {
            return new GlVersion(4, 1);
        }
        if (glCapabilities.OpenGL40) {
            return new GlVersion(4, 0);
        }
        if (glCapabilities.OpenGL33) {
            return new GlVersion(3, 3);
        }
        if (glCapabilities.OpenGL32) {
            return new GlVersion(3, 2);
        }
        if (glCapabilities.OpenGL31) {
            return new GlVersion(3, 1);
        }
        if (glCapabilities.OpenGL30) {
            return new GlVersion(3, 0);
        }
        if (glCapabilities.OpenGL21) {
            return new GlVersion(2, 1);
        }
        if (glCapabilities.OpenGL20) {
            return new GlVersion(2, 0);
        }
        if (glCapabilities.OpenGL15) {
            return new GlVersion(1, 5);
        }
        if (glCapabilities.OpenGL14) {
            return new GlVersion(1, 4);
        }
        if (glCapabilities.OpenGL13) {
            return new GlVersion(1, 3);
        }
        if (glCapabilities.OpenGL12) {
            return new GlVersion(1, 2);
        }
        if (glCapabilities.OpenGL11) {
            return new GlVersion(1, 1);
        }
        return new GlVersion(1, 0);
    }

    public static GlVersion getGlVersion() {
        if (glVersion == null) {
            String verStr = GL11.glGetString((int)7938);
            glVersion = Config.parseGlVersion((String)verStr, null);
            if (glVersion == null) {
                glVersion = Config.getGlVersionLwjgl();
            }
            if (glVersion == null) {
                glVersion = new GlVersion(1, 0);
            }
        }
        return glVersion;
    }

    public static GlVersion getGlslVersion() {
        String verStr;
        if (glslVersion == null && (glslVersion = Config.parseGlVersion((String)(verStr = GL11.glGetString((int)35724)), null)) == null) {
            glslVersion = new GlVersion(1, 10);
        }
        return glslVersion;
    }

    public static GlVersion parseGlVersion(String versionString, GlVersion def) {
        try {
            if (versionString == null) {
                return def;
            }
            Pattern REGEXP_VERSION = Pattern.compile("([0-9]+)\\.([0-9]+)(\\.([0-9]+))?(.+)?");
            Matcher matcher = REGEXP_VERSION.matcher(versionString);
            if (!matcher.matches()) {
                return def;
            }
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int release = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            String suffix = matcher.group(5);
            return new GlVersion(major, minor, release, suffix);
        }
        catch (Exception e) {
            Config.error((String)"", (Throwable)e);
            return def;
        }
    }

    public static String[] getOpenGlExtensions() {
        if (openGlExtensions == null) {
            openGlExtensions = Config.detectOpenGlExtensions();
        }
        return openGlExtensions;
    }

    private static String[] detectOpenGlExtensions() {
        try {
            int countExt;
            GlVersion ver = Config.getGlVersion();
            if (ver.getMajor() >= 3 && (countExt = GL11.glGetInteger((int)33309)) > 0) {
                String[] exts = new String[countExt];
                for (int i2 = 0; i2 < countExt; ++i2) {
                    exts[i2] = GL30.glGetStringi((int)7939, (int)i2);
                }
                return exts;
            }
        }
        catch (Exception e) {
            Config.error((String)"", (Throwable)e);
        }
        try {
            String extStr = GL11.glGetString((int)7939);
            String[] exts = extStr.split(" ");
            return exts;
        }
        catch (Exception e) {
            Config.error((String)"", (Throwable)e);
            return new String[0];
        }
    }

    public static void updateThreadPriorities() {
        Config.updateAvailableProcessors();
        int ELEVATED_PRIORITY = 8;
        if (Config.isSingleProcessor()) {
            if (Config.isSmoothWorld()) {
                minecraftThread.setPriority(10);
                Config.setThreadPriority((String)"Server thread", (int)1);
            } else {
                minecraftThread.setPriority(5);
                Config.setThreadPriority((String)"Server thread", (int)5);
            }
        } else {
            minecraftThread.setPriority(10);
            Config.setThreadPriority((String)"Server thread", (int)5);
        }
    }

    private static void setThreadPriority(String prefix, int priority) {
        try {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            if (tg == null) {
                return;
            }
            int num = (tg.activeCount() + 10) * 2;
            Thread[] ts = new Thread[num];
            tg.enumerate(ts, false);
            for (int i2 = 0; i2 < ts.length; ++i2) {
                Thread t = ts[i2];
                if (t == null || !t.getName().startsWith(prefix)) continue;
                t.setPriority(priority);
            }
        }
        catch (Throwable e) {
            Config.warn((String)(e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    public static boolean isMinecraftThread() {
        return Thread.currentThread() == minecraftThread;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread vct = new VersionCheckThread();
        vct.start();
    }

    public static boolean isMipmaps() {
        return (Integer)gameSettings.K().b() > 0;
    }

    public static int getMipmapLevels() {
        return (Integer)gameSettings.K().b();
    }

    public static int getMipmapType() {
        switch (Config.gameSettings.ofMipmapType) {
            case 0: {
                return 9986;
            }
            case 1: {
                return 9986;
            }
            case 2: {
                if (Config.isMultiTexture()) {
                    return 9985;
                }
                return 9986;
            }
            case 3: {
                if (Config.isMultiTexture()) {
                    return 9987;
                }
                return 9986;
            }
        }
        return 9986;
    }

    public static boolean isUseAlphaFunc() {
        float alphaFuncLevel = Config.getAlphaFuncLevel();
        return alphaFuncLevel > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogOff() {
        return Config.gameSettings.ofFogType == 3;
    }

    public static boolean isFogOn() {
        return Config.gameSettings.ofFogType != 3;
    }

    public static float getFogStart() {
        return Config.gameSettings.ofFogStart;
    }

    public static void detail(String s) {
        if (logDetail) {
            LOGGER.info("[OptiFine] " + s);
        }
    }

    public static void dbg(String s) {
        LOGGER.info("[OptiFine] " + s);
    }

    public static void warn(String s) {
        LOGGER.warn("[OptiFine] " + s);
    }

    public static void warn(String s, Throwable t) {
        LOGGER.warn("[OptiFine] " + s, t);
    }

    public static void error(String s) {
        LOGGER.error("[OptiFine] " + s);
    }

    public static void error(String s, Throwable t) {
        LOGGER.error("[OptiFine] " + s, t);
    }

    public static void log(String s) {
        Config.dbg((String)s);
    }

    public static void dbg(String[] strs) {
        for (String str : strs) {
            Config.dbg((String)str);
        }
    }

    public static int getUpdatesPerFrame() {
        return Config.gameSettings.ofChunkUpdates;
    }

    public static boolean isDynamicUpdates() {
        return Config.gameSettings.ofChunkUpdatesDynamic;
    }

    public static boolean isGraphicsFabulous() {
        return (Boolean)gameSettings.p().b();
    }

    public static boolean isRainFast() {
        return (Integer)gameSettings.m().b() <= 5;
    }

    public static boolean isRainOff() {
        return (Integer)gameSettings.m().b() < 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isFancy();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 2;
        }
        return gameSettings.k().b() == gev.c;
    }

    public static boolean isCloudsOff() {
        if (Config.isShaders() && !Shaders.shaderPackClouds.isDefault()) {
            return Shaders.shaderPackClouds.isOff();
        }
        if (texturePackClouds != 0) {
            return texturePackClouds == 3;
        }
        return gameSettings.k().b() == gev.a;
    }

    public static void updateTexturePackClouds() {
        texturePackClouds = 0;
        baz rm = Config.getResourceManager();
        if (rm == null) {
            return;
        }
        try {
            InputStream in = rm.getResourceOrThrow(new amo("optifine/color.properties")).d();
            if (in == null) {
                return;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            String cloudStr = props.getProperty("clouds");
            if (cloudStr == null) {
                return;
            }
            Config.dbg((String)("Texture pack clouds: " + cloudStr));
            cloudStr = cloudStr.toLowerCase();
            if (cloudStr.equals("fast")) {
                texturePackClouds = 1;
            }
            if (cloudStr.equals("fancy")) {
                texturePackClouds = 2;
            }
            if (cloudStr.equals("off") || cloudStr.equals("none")) {
                texturePackClouds = 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static iob getModelManager() {
        return minecraft.aK();
    }

    public static boolean isTreesFancy() {
        return Config.gameSettings.ofTrees != 1;
    }

    public static boolean isTreesSmart() {
        return Config.gameSettings.ofTrees == 4;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static long limit(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static double limit(double val, double min, double max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limitTo1(float val) {
        if (val < 0.0f) {
            return 0.0f;
        }
        if (val > 1.0f) {
            return 1.0f;
        }
        return val;
    }

    public static boolean isAnimatedWater() {
        return Config.gameSettings.ofAnimatedWater != 2;
    }

    public static boolean isGeneratedWater() {
        return Config.gameSettings.ofAnimatedWater == 1;
    }

    public static boolean isAnimatedPortal() {
        return Config.gameSettings.ofAnimatedPortal;
    }

    public static boolean isAnimatedLava() {
        return Config.gameSettings.ofAnimatedLava != 2;
    }

    public static boolean isGeneratedLava() {
        return Config.gameSettings.ofAnimatedLava == 1;
    }

    public static boolean isAnimatedFire() {
        return Config.gameSettings.ofAnimatedFire;
    }

    public static boolean isAnimatedRedstone() {
        return Config.gameSettings.ofAnimatedRedstone;
    }

    public static boolean isAnimatedExplosion() {
        return Config.gameSettings.ofAnimatedExplosion;
    }

    public static boolean isAnimatedFlame() {
        return Config.gameSettings.ofAnimatedFlame;
    }

    public static boolean isAnimatedSmoke() {
        return Config.gameSettings.ofAnimatedSmoke;
    }

    public static boolean isVoidParticles() {
        return Config.gameSettings.ofVoidParticles;
    }

    public static boolean isWaterParticles() {
        return Config.gameSettings.ofWaterParticles;
    }

    public static boolean isRainSplash() {
        return Config.gameSettings.ofRainSplash;
    }

    public static boolean isPortalParticles() {
        return Config.gameSettings.ofPortalParticles;
    }

    public static boolean isPotionParticles() {
        return Config.gameSettings.ofPotionParticles;
    }

    public static boolean isFireworkParticles() {
        return Config.gameSettings.ofFireworkParticles;
    }

    public static float getAmbientOcclusionLevel() {
        if (Config.isShaders() && Shaders.aoLevel >= 0.0f) {
            return Shaders.aoLevel;
        }
        return (float)Config.gameSettings.ofAoLevel;
    }

    public static String listToString(List list) {
        return Config.listToString((List)list, (String)", ");
    }

    public static String listToString(List list, String separator) {
        if (list == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(list.size() * 5);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object obj = list.get(i2);
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] arr) {
        return Config.arrayToString((Object[])arr, (String)", ");
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr) {
        return Config.arrayToString((int[])arr, (String)", ");
    }

    public static String arrayToString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            int x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr) {
        return Config.arrayToString((float[])arr, (String)", ");
    }

    public static String arrayToString(float[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            float x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static gfj getMinecraft() {
        return minecraft;
    }

    public static ilr getTextureManager() {
        return minecraft.af();
    }

    public static baz getResourceManager() {
        return minecraft.ah();
    }

    public static InputStream getResourceStream(amo location) throws IOException {
        return Config.getResourceStream((baz)minecraft.ah(), (amo)location);
    }

    public static InputStream getResourceStream(baz resourceManager, amo location) throws IOException {
        bax res = resourceManager.getResourceOrThrow(location);
        if (res == null) {
            return null;
        }
        return res.d();
    }

    public static bax getResource(amo location) throws IOException {
        return minecraft.ah().getResourceOrThrow(location);
    }

    public static Optional<bax> getResourceSafe(amo location) {
        return minecraft.ah().getResource(location);
    }

    public static boolean hasResource(amo location) {
        if (location == null) {
            return false;
        }
        azl rp = Config.getDefiningResourcePack((amo)location);
        return rp != null;
    }

    public static boolean hasResource(baz resourceManager, amo location) {
        try {
            bax res = resourceManager.getResourceOrThrow(location);
            return res != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean hasResource(azl rp, amo loc) {
        if (rp == null || loc == null) {
            return false;
        }
        bar supplier = rp.a(azn.a, loc);
        return supplier != null;
    }

    public static azl[] getResourcePacks() {
        bak rep = minecraft.ai();
        Collection packInfos = rep.g();
        ArrayList<azl> list = new ArrayList<azl>();
        for (bah rpic : packInfos) {
            azl rp = rpic.f();
            if (rp == Config.getDefaultResourcePack()) continue;
            list.add(rp);
        }
        azl[] rps = list.toArray(new azl[list.size()]);
        return rps;
    }

    public static String getResourcePackNames() {
        if (minecraft.ah() == null) {
            return "";
        }
        azl[] rps = Config.getResourcePacks();
        if (rps.length <= 0) {
            return Config.getDefaultResourcePack().b();
        }
        Object[] names = new String[rps.length];
        for (int i2 = 0; i2 < rps.length; ++i2) {
            names[i2] = rps[i2].b();
        }
        String nameStr = Config.arrayToString((Object[])names);
        return nameStr;
    }

    public static azp getDefaultResourcePack() {
        return minecraft.aj();
    }

    public static boolean isFromDefaultResourcePack(amo loc) {
        return Config.getDefiningResourcePack((amo)loc) == Config.getDefaultResourcePack();
    }

    public static azl getDefiningResourcePack(amo location) {
        bak rep = minecraft.ai();
        Collection packInfos = rep.g();
        List entries = (List)packInfos;
        for (int i2 = entries.size() - 1; i2 >= 0; --i2) {
            bah entry = (bah)entries.get(i2);
            azl rp = entry.f();
            if (rp.a(azn.a, location) == null) continue;
            return rp;
        }
        return null;
    }

    public static InputStream getResourceStream(azl rp, azn type, amo location) throws IOException {
        bar supplier = rp.a(type, location);
        if (supplier == null) {
            return null;
        }
        return (InputStream)supplier.get();
    }

    public static hoh getRenderGlobal() {
        return Config.minecraft.e;
    }

    public static hoh getWorldRenderer() {
        return Config.minecraft.e;
    }

    public static hob getGameRenderer() {
        return Config.minecraft.i;
    }

    public static hwo getEntityRenderDispatcher() {
        return minecraft.ay();
    }

    public static boolean isBetterGrass() {
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static boolean isWeatherEnabled() {
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        return Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        return Config.gameSettings.ofSunMoon;
    }

    public static boolean isSunTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isSun();
    }

    public static boolean isMoonTexture() {
        if (!Config.isSunMoonEnabled()) {
            return false;
        }
        return !Config.isShaders() || Shaders.isMoon();
    }

    public static boolean isVignetteEnabled() {
        if (Config.isShaders() && !Shaders.isVignette()) {
            return false;
        }
        return (Boolean)gameSettings.o().b();
    }

    public static boolean isStarsEnabled() {
        return Config.gameSettings.ofStars;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Config.error((String)"", (Throwable)e);
        }
    }

    public static boolean isTimeDayOnly() {
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeDefault() {
        return Config.gameSettings.ofTime == 0;
    }

    public static boolean isTimeNightOnly() {
        return Config.gameSettings.ofTime == 2;
    }

    public static int getAnisotropicFilterLevel() {
        return Config.gameSettings.ofAfLevel;
    }

    public static boolean isAnisotropicFiltering() {
        return Config.getAnisotropicFilterLevel() > 1;
    }

    public static int getAntialiasingLevel() {
        return antialiasingLevel;
    }

    public static boolean isAntialiasing() {
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean isAntialiasingConfigured() {
        return Config.getGameSettings().ofAaLevel > 0;
    }

    public static boolean isMultiTexture() {
        if (Config.getAnisotropicFilterLevel() > 1) {
            return true;
        }
        return Config.getAntialiasingLevel() > 0;
    }

    public static boolean between(int val, int min, int max) {
        return val >= min && val <= max;
    }

    public static boolean between(float val, float min, float max) {
        return val >= min && val <= max;
    }

    public static boolean between(double val, double min, double max) {
        return val >= min && val <= max;
    }

    public static boolean isDrippingWaterLava() {
        return Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        return Config.gameSettings.ofBetterSnow;
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static int parseHexInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            if ((str = str.trim()).startsWith("0x")) {
                str = str.substring(2);
            }
            return Integer.parseInt(str, 16);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static float parseFloat(String str, float defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static boolean parseBoolean(String str, boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Boolean.parseBoolean(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static Boolean parseBoolean(String str, Boolean defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            if ((str = str.trim().toLowerCase()).equals("true")) {
                return Boolean.TRUE;
            }
            if (str.equals("false")) {
                return Boolean.FALSE;
            }
            return defVal;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        String[] strs = list.toArray(new String[list.size()]);
        return strs;
    }

    public static boolean isAnimatedTerrain() {
        return Config.gameSettings.ofAnimatedTerrain;
    }

    public static boolean isAnimatedTextures() {
        return Config.gameSettings.ofAnimatedTextures;
    }

    public static boolean isSwampColors() {
        return Config.gameSettings.ofSwampColors;
    }

    public static boolean isRandomEntities() {
        return Config.gameSettings.ofRandomEntities;
    }

    public static void checkGlError(String loc) {
        int errorCode = GlStateManager._getError();
        if (errorCode != 0 && GlErrors.isEnabled((int)errorCode)) {
            String errorText = Config.getGlErrorString((int)errorCode);
            String messageLog = String.format("OpenGL error: %s (%s), at: %s", errorCode, errorText, loc);
            Config.error((String)messageLog);
            if (Config.isShowGlErrors() && TimedEvent.isActive((String)"ShowGlError", (long)10000L)) {
                String message = imu.a((String)"of.message.openglError", (Object[])new Object[]{errorCode, errorText});
                Config.minecraft.j.e().a((yh)yh.b((String)message));
            }
        }
    }

    public static boolean isSmoothBiomes() {
        return (Integer)gameSettings.P().b() > 0;
    }

    public static int getBiomeBlendRadius() {
        return (Integer)gameSettings.P().b();
    }

    public static boolean isCustomColors() {
        return Config.gameSettings.ofCustomColors;
    }

    public static boolean isCustomSky() {
        return Config.gameSettings.ofCustomSky;
    }

    public static boolean isCustomFonts() {
        return Config.gameSettings.ofCustomFonts;
    }

    public static boolean isShowCapes() {
        return Config.gameSettings.ofShowCapes;
    }

    public static boolean isConnectedTextures() {
        return Config.gameSettings.ofConnectedTextures != 3;
    }

    public static boolean isNaturalTextures() {
        return Config.gameSettings.ofNaturalTextures;
    }

    public static boolean isEmissiveTextures() {
        return Config.gameSettings.ofEmissiveTextures;
    }

    public static boolean isConnectedTexturesFancy() {
        return Config.gameSettings.ofConnectedTextures == 2;
    }

    public static boolean isFastRender() {
        return Config.gameSettings.ofFastRender;
    }

    public static boolean isShaders() {
        return Shaders.shaderPackLoaded;
    }

    public static boolean isShadersShadows() {
        return Config.isShaders() && Shaders.hasShadowMap;
    }

    public static String[] readLines(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return Config.readLines((InputStream)fis);
    }

    public static String[] readLines(InputStream is2) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is2, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }

    public static String readFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        return Config.readInputStream((InputStream)fin, (String)"ASCII");
    }

    public static String readInputStream(InputStream in) throws IOException {
        return Config.readInputStream((InputStream)in, (String)"ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(in, encoding);
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    public static byte[] readAll(InputStream is2) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is2.read(buf)) >= 0) {
            baos.write(buf, 0, len);
        }
        is2.close();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public static String readAll(Reader reader) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) > 0) {
            sb.append(buf, 0, len);
        }
        reader.close();
        return sb.toString();
    }

    public static gfo getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String newRelease) {
        Config.newRelease = newRelease;
    }

    public static int compareRelease(String rel1, String rel2) {
        int rev2;
        String[] rels2;
        String branch2;
        String[] rels1 = Config.splitRelease((String)rel1);
        String branch1 = rels1[0];
        if (!branch1.equals(branch2 = (rels2 = Config.splitRelease((String)rel2))[0])) {
            return branch1.compareTo(branch2);
        }
        int rev1 = Config.parseInt((String)rels1[1], (int)-1);
        if (rev1 != (rev2 = Config.parseInt((String)rels2[1], (int)-1))) {
            return rev1 - rev2;
        }
        String suf1 = rels1[2];
        String suf2 = rels2[2];
        if (!suf1.equals(suf2)) {
            if (suf1.isEmpty()) {
                return 1;
            }
            if (suf2.isEmpty()) {
                return -1;
            }
        }
        return suf1.compareTo(suf2);
    }

    private static String[] splitRelease(String relStr) {
        if (relStr == null || relStr.length() <= 0) {
            return new String[]{"", "", ""};
        }
        Pattern p = Pattern.compile("([A-Z])([0-9]+)(.*)");
        Matcher m = p.matcher(relStr);
        if (!m.matches()) {
            return new String[]{"", "", ""};
        }
        String branch = Config.normalize((String)m.group(1));
        String revision = Config.normalize((String)m.group(2));
        String suffix = Config.normalize((String)m.group(3));
        return new String[]{branch, revision, suffix};
    }

    public static int intHash(int x) {
        x = x ^ 0x3D ^ x >> 16;
        x += x << 3;
        x ^= x >> 4;
        x *= 668265261;
        x ^= x >> 15;
        return x;
    }

    public static int getRandom(is blockPos, int face) {
        int rand = Config.intHash((int)(face + 37));
        rand = Config.intHash((int)(rand + blockPos.u()));
        rand = Config.intHash((int)(rand + blockPos.w()));
        rand = Config.intHash((int)(rand + blockPos.v()));
        return rand;
    }

    public static int getAvailableProcessors() {
        return availableProcessors;
    }

    public static void updateAvailableProcessors() {
        availableProcessors = Runtime.getRuntime().availableProcessors();
    }

    public static boolean isSingleProcessor() {
        return Config.getAvailableProcessors() <= 1;
    }

    public static boolean isSmoothWorld() {
        return Config.gameSettings.ofSmoothWorld;
    }

    public static boolean isLazyChunkLoading() {
        return Config.gameSettings.ofLazyChunkLoading;
    }

    public static boolean isAlternateBlocks() {
        return Config.gameSettings.ofAlternateBlocks;
    }

    public static int getChunkViewDistance() {
        if (gameSettings == null) {
            return 10;
        }
        int chunkDistance = (Integer)gameSettings.e().b();
        return chunkDistance;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean equalsOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b = bs[i2];
            if (!Config.equals((Object)a2, (Object)b)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(int val, int[] vals) {
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (vals[i2] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i2 = 0; i2 < bs.length; ++i2) {
            Object b = bs[i2];
            if (a2 != b) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static ByteBuffer readIconImage(InputStream is2) throws IOException {
        BufferedImage var2 = ImageIO.read(is2);
        int[] var3 = var2.getRGB(0, 0, var2.getWidth(), var2.getHeight(), null, 0, var2.getWidth());
        ByteBuffer var4 = ByteBuffer.allocate(4 * var3.length);
        int[] var5 = var3;
        int var6 = var3.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            int var8 = var5[var7];
            var4.putInt(var8 << 8 | var8 >> 24 & 0xFF);
        }
        var4.flip();
        return var4;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = arr.length;
        int newLen = arrLen + 1;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        newArr[arrLen] = obj;
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.add(index, obj);
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(newArr);
    }

    public static Object[] addObjectsToArray(Object[] arr, Object[] objs) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr;
        }
        int arrLen = arr.length;
        int newLen = arrLen + objs.length;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        System.arraycopy(objs, 0, newArr, arrLen, objs.length);
        return newArr;
    }

    public static Object[] removeObjectFromArray(Object[] arr, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.remove(obj);
        Object[] newArr = Config.collectionToArray(list, arr.getClass().getComponentType());
        return newArr;
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + String.valueOf(elementClass));
        }
        Object[] array = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(array);
    }

    public static boolean isCustomItems() {
        return Config.gameSettings.ofCustomItems;
    }

    public static String getFpsString() {
        int fps = Config.getFpsAverage();
        int fpsMin = Config.getFpsMin();
        if (showFrameTime) {
            String timeMs = String.format("%.1f", 1000.0 / (double)Config.limit((int)fps, (int)1, (int)Integer.MAX_VALUE));
            String timeMaxMs = String.format("%.1f", 1000.0 / (double)Config.limit((int)fpsMin, (int)1, (int)Integer.MAX_VALUE));
            String fpsStr = timeMs + "/" + timeMaxMs + " ms";
            return fpsStr;
        }
        String fpsStr = fps + "/" + fpsMin + " fps";
        return fpsStr;
    }

    public static boolean isShowFrameTime() {
        return showFrameTime;
    }

    public static int getFpsAverage() {
        return minecraft.s();
    }

    public static int getFpsMin() {
        return fpsMinLast;
    }

    public static int getChunkUpdates() {
        return chunkUpdatesLast;
    }

    public static void updateFpsMin() {
        long timeAvgNs;
        bxn sl = minecraft.aT().getFrameTimeLogger();
        if (sl.d() <= 0) {
            return;
        }
        int fps = Config.getFpsAverage();
        if (fps <= 0) {
            fps = 1;
        }
        long timeMaxNs = timeAvgNs = (long)(1.0 / (double)fps * 1.0E9);
        long timeTotalNs = 0L;
        for (int ix = sl.d() - 1; ix > 0 && (double)timeTotalNs < 1.0E9; --ix) {
            long timeNs = sl.a(ix);
            if (timeNs > timeMaxNs) {
                timeMaxNs = timeNs;
            }
            timeTotalNs += timeNs;
        }
        double timeMaxSec = (double)timeMaxNs / 1.0E9;
        fpsMinLast = (int)(1.0 / timeMaxSec);
    }

    private static void updateChunkUpdates() {
        chunkUpdatesLast = hts.renderChunksUpdated;
        hts.renderChunksUpdated = 0;
    }

    public static int getBitsOs() {
        String progFiles86 = System.getenv("ProgramFiles(X86)");
        if (progFiles86 != null) {
            return 64;
        }
        return 32;
    }

    public static int getBitsJre() {
        String[] propNames = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"};
        for (int i2 = 0; i2 < propNames.length; ++i2) {
            String propName = propNames[i2];
            String propVal = System.getProperty(propName);
            if (propVal == null || !propVal.contains("64")) continue;
            return 64;
        }
        return 32;
    }

    public static boolean isNotify64BitJava() {
        return notify64BitJava;
    }

    public static void setNotify64BitJava(boolean flag) {
        notify64BitJava = flag;
    }

    public static boolean isConnectedModels() {
        return false;
    }

    public static void showGuiMessage(String line1, String line2) {
        GuiMessage gui = new GuiMessage(Config.minecraft.x, line1, line2);
        minecraft.a((gsb)gui);
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return Config.addIntsToArray((int[])intArray, (int[])new int[]{intValue});
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray == null || copyFrom == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = intArray.length;
        int newLen = arrLen + copyFrom.length;
        int[] newArray = new int[newLen];
        System.arraycopy(intArray, 0, newArray, 0, arrLen);
        for (int index = 0; index < copyFrom.length; ++index) {
            newArray[index + arrLen] = copyFrom[index];
        }
        return newArray;
    }

    public static void writeFile(File file, String str) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = str.getBytes("ASCII");
        fos.write(bytes);
        fos.close();
    }

    public static void setTextureMapBlocks(ilo textureMap) {
        textureMapBlocks = textureMap;
    }

    public static ilo getTextureMapBlocks() {
        return textureMapBlocks;
    }

    public static void setTextureMapItems(ilo textureMap) {
        textureMapItems = textureMap;
    }

    public static ilo getTextureMapItems() {
        return textureMapItems;
    }

    public static inl getAtlasManager() {
        return minecraft.aL();
    }

    public static boolean isDynamicLights() {
        return Config.gameSettings.ofDynamicLights != 3;
    }

    public static boolean isDynamicLightsFast() {
        return Config.gameSettings.ofDynamicLights == 1;
    }

    public static boolean isDynamicHandLight() {
        if (!Config.isDynamicLights()) {
            return false;
        }
        if (Config.isShaders()) {
            return Shaders.isDynamicHandLight();
        }
        return true;
    }

    public static boolean isCustomEntityModels() {
        return Config.gameSettings.ofCustomEntityModels;
    }

    public static boolean isCustomGuis() {
        return Config.gameSettings.ofCustomGuis;
    }

    public static int getScreenshotSize() {
        return Config.gameSettings.ofScreenshotSize;
    }

    public static int[] toPrimitive(Integer[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new int[0];
        }
        int[] intArr = new int[arr.length];
        for (int i2 = 0; i2 < intArr.length; ++i2) {
            intArr[i2] = arr[i2];
        }
        return intArr;
    }

    public static boolean isRenderRegions() {
        if (Config.isMultiTexture()) {
            return false;
        }
        return Config.gameSettings.ofRenderRegions && GlStateManager.vboRegions;
    }

    public static boolean isMainFramebufferEnabled() {
        return !Config.isAntialiasing();
    }

    public static boolean isSmoothFps() {
        return Config.gameSettings.ofSmoothFps;
    }

    public static boolean openWebLink(URI uri) {
        bhs.setExceptionOpenUrl(null);
        bhs.n().a(uri);
        Exception error = bhs.getExceptionOpenUrl();
        return error == null;
    }

    public static boolean isShowGlErrors() {
        return Config.gameSettings.ofShowGlErrors;
    }

    public static String arrayToString(boolean[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            boolean x = arr[i2];
            if (i2 > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static boolean isIntegratedServerRunning() {
        if (minecraft.aa() == null) {
            return false;
        }
        return minecraft.Y();
    }

    public static IntBuffer createDirectIntBuffer(int capacity) {
        return GlUtil.allocateMemory((int)(capacity << 2)).asIntBuffer();
    }

    public static PointerBuffer createDirectPointerBuffer(int capacity) {
        return PointerBuffer.allocateDirect((int)capacity);
    }

    public static String getGlErrorString(int err) {
        switch (err) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Invalid enum";
            }
            case 1281: {
                return "Invalid value";
            }
            case 1282: {
                return "Invalid operation";
            }
            case 1286: {
                return "Invalid framebuffer operation";
            }
            case 1285: {
                return "Out of memory";
            }
            case 1284: {
                return "Stack underflow";
            }
            case 1283: {
                return "Stack overflow";
            }
        }
        return "Unknown";
    }

    public static boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)minecraft.aR().h(), (int)key) == 1;
    }

    public static boolean isTrue(Boolean val) {
        return val != null && val != false;
    }

    public static boolean isFalse(Boolean val) {
        return val != null && val == false;
    }

    public static boolean isReloadingResources() {
        grr rlpg;
        if (minecraft.aP() == null) {
            return false;
        }
        return !(minecraft.aP() instanceof grr) || !(rlpg = (grr)minecraft.aP()).isFadeOut();
    }

    public static boolean isQuadsToTriangles() {
        if (!Config.isShaders()) {
            return false;
        }
        return !Shaders.canRenderQuads();
    }

    public static void frameStart() {
        long timeNowMs = System.currentTimeMillis();
        long frameTimeMs = timeNowMs - timeLastFrameMs;
        timeLastFrameMs = timeNowMs;
        frameTimeMs = Config.limit((long)frameTimeMs, (long)1L, (long)1000L);
        averageFrameTimeMs = (averageFrameTimeMs + frameTimeMs) / 2L;
        averageFrameTimeMs = Config.limit((long)averageFrameTimeMs, (long)1L, (long)1000L);
        lastFrameTimeMs = frameTimeMs;
        long debugUpdateTime = Reflector.getFieldValueLong((Object)minecraft, (ReflectorField)Reflector.Minecraft_debugUpdateTime, (long)-1L);
        if (debugUpdateTime != debugUpdateTimeLast) {
            debugUpdateTimeLast = debugUpdateTime;
            Config.updateFpsMin();
            Config.updateChunkUpdates();
        }
    }

    public static long getLastFrameTimeMs() {
        return lastFrameTimeMs;
    }

    public static long getAverageFrameTimeMs() {
        return averageFrameTimeMs;
    }

    public static float getAverageFrameTimeSec() {
        float frameTimeSec = (float)Config.getAverageFrameTimeMs() / 1000.0f;
        return frameTimeSec;
    }

    public static long getAverageFrameFps() {
        long frameFps = 1000L / Config.getAverageFrameTimeMs();
        return frameFps;
    }

    public static void checkNull(Object obj, String msg) throws NullPointerException {
        if (obj == null) {
            throw new NullPointerException(msg);
        }
    }

    public static boolean isTelemetryOn() {
        return Config.gameSettings.ofTelemetry != 2;
    }

    public static boolean isTelemetryAnonymous() {
        return Config.gameSettings.ofTelemetry == 1;
    }

    static {
        showFrameTime = Boolean.getBoolean("frame.time");
    }
}

